﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class ReferralAutoTriageDB : DBUtils
    {
        public int AutoTriageAcceptedReferrals()
        {
            using (EFRDB2DataContext dbContext = GetEfr2DataContext())
            {
                int? records = 0;
                dbContext.AutoTriageReferrals_Accept(ref records);

                return records.Value;
            }
        }

        public int AutoTriageDuplicates()
        {
            using (EFRDB2DataContext dbContext = GetEfr2DataContext())
            {
                int? records = 0;
                dbContext.AutoTriageReferrals_Duplicates(ref records);

                return records.Value;
            }
        }

        public int AutoTriageIneligibles()
        {
            using (EFRDB2DataContext dbContext = GetEfr2DataContext())
            {
                int? records = 0;
                dbContext.AutoTriageReferrals_Ineligible(ref records);

                return records.Value;
            }
        }

        public int AutoTriageReferralCount()
        {
            using (EFRDB2DataContext dbContext = GetEfr2DataContext())
            {
                AutoTriageReferralsCountResult result = null;
                result = dbContext.AutoTriageReferralsCount().Single();
                int? referralsCount = result.ReferralsCount;

                return referralsCount.Value;
            }
        }
    }
}
